@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 ">System Signals</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />
                <div class="mb-5 row">
                    <div class="mt-2 mb-3 col-lg-12">
                        <a class="btn btn-primary" href="{{ route('newsignal') }}"><i class="fa fa-plus"></i> New plan</a>
                    </div>
                    @forelse ($signals as $signal)
                        <div class="col-lg-4">
                            <div class="pricing-table purple border p-4 card">
                                <div class="card-body">
                                    <h2 class="">{{ $signal->name }} <span
                                class="fs-3 fw-normal text-success">{{ $signal->tag ?? '' }}</span></h2>
                                    <!-- Price -->
                                    <div class="price-tag">
                                        <span class="symbol ">{{ $settings->currency }}</span>
                                        <span class="amount ">{{ number_format($signal->price) }}</span>
                                    </div>
                                    <!-- Features -->
                                    <div class="pricing-features">
                                        <div class="feature text-dark">Signal Price:<span
                                                class="">{{ $settings->currency }}{{ number_format($signal->price) }}</span>
                                        </div>
                                       
                                        <div class="feature text-dark">Percentage:<span
                                                class="">{{ $signal->increment_amount	 }}%</span>
                                        </div>
                                    </div> <br>

                                    <!-- Button -->
                                    <div class="text-center">
                                        <a href="{{ route('editsignal', $signal->id) }}" class="btn btn-primary"><i
                                                class="text-white flaticon-pencil"></i>
                                        </a> &nbsp;
                                        <a href="{{ url('admin/dashboard/trashsignal') }}/{{ $signal->id }}"
                                            class="btn btn-danger"><i class="text-white fa fa-times"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="col-lg-12 text-center">
                            <div class="pricing-table card purple border p-4">
                                <h4 class="">No Investment Plan at the moment, click the button above to add a plan.
                                </h4>
                            </div>
                        </div>
                    @endforelse

                </div>
            </div>
        </div>
    @endsection
